# Session settings

## Settings
Here you can define all the parameters for your single player session including weather presets, opponents, time of day, amount of rubber on track, and more.

### Practice
In a practice session you can run laps and get to know the layout.

### Qualifying
In a qualifying session you push for the fastest possible lap time to claim your starting position for the race.

### Warmup
In a warmup session you can perform final checks on the car and prepare for the race.

### Race
The race session is the real thing, here you compete with your opponents for the win!

### Time Scale
Multiplying the time scale will accelerate the day/night cycle.

### Flag Rules
Change how the flag rules are enforced. "Full w/o DQ" will show you warning notifications for things like speeding in the pit lane, but you can continue driving without getting disqualified.

### Track Limits Rules
This sets up the thresholds for penalties and warnings for infringements. In non race sessions the penalty is just to invalidate your current and possibly next lap. In a race you earn points. Once you pass the maximum track limits points allowed, a drive through penalty is issued.

A dialogue will show when you are at risk of an infringement. You will have a brief opportunity to slow down whilst the situation is calculated to avoid a penalty. If you pass another driver whilst off track illegally, then a dialogue will recommend you to give back the place.

When using the strict setting, thresholds for off track and wall riding are reduced, penalty points are increased and any off track in non race sessions will invalidate your lap.

### Fuel Usage
Multiplying the fuel usage will increase the amount of fuel that is consumed by the engine.

### Mechanical Failures
"Time Scaled" will scale the reliability of the car components (engine, brakes) to the length of the session. This means in shorter sessions it's more likely to see failures compared to having this setting set to "Normal".

### Tire Wear
Multiplying the tire wear will increase degradation on the tires caused by sliding and overheating.

### Weather Preset
Select a weather preset that will apply to all sessions. You can customize the weather for each session separately in the session tabs above.

### Damage Multiplier
This setting lets you adjust how much damage your car sustains in collisions and crashes.

### AI Drivers
This setting lets you change the amount of AI-controlled opponents. You can filter which cars the AI-controlled opponents can use to the right.

### AI Strength
This setting determines the relative speed with which AI-controlled opponents will ace you. That speed is calculated taking your car and the track you race on into account. It may take some experimenting with this setting to find the best level of AI strength to practice against.

### AI Aggression
This setting determines how aggressively the AI-controlled opponents race against you, for instance in the way they take corners and overtake you.

## Practice
In a practice session you can run laps and get to know the layout.

## Qualifying
In a qualifying session you push for the fastest possible lap time to claim your starting position for the race.

## Warmup
In a warmup session you can perform final checks on the car and prepare for the race.

## Race
The race session is the real thing, here you compete with your opponents for the win!

### Start Time
Set the start time of the session.

### Private Practice
Enabling private practice will make all opponents invisible.

### Practice Time
Set the length of the practice session.

### Private Qualifying
Enabling private practice will make all opponents invisible.

### Qualifying Laps
Set a limit on the amount of laps allowed to run in the qualifying session.

### Qualifying Time
Set the length of the qualifying session.

### Warmup Start Time
Set the start time of the warmup session.

### Race Start Type
Determine the start type of the race session.

**Standing:** The race starts with the cars standing still.

**Formation/Standing:** All cars do a slow lap around the track and find their grid spot. The race starts with the cars standing still.

**Rolling:** All cars do a slow lap around the track. Follow the on-screen instructions. The race starts in rolling formation.

**Fast Rolling:** Cars start a few seconds before the green flag. Follow the on-screen instructions. The race starts in rolling formation.

**Track:** Uses the default setting determined in the track configuration.

### Grid Position
Determines your starting position for the race.

When a qualifying session is enabled, this setting has no effect and is disabled.

### Finish Criteria
**Laps:** race will finish when the set number of laps have been completed.

**Time:** race will finish on the lap that the remaining time reaches 0.

**Laps and Time:** race will finish when laps or time criteria is reached, whichever happens first.

**% Track Laps:** race length is the percentage of the default track laps, so this will vary from track to track.

**% Track Time:** race length is the percentage of the default track time, so this will vary from track to track.

**% Track Default:** race length is either the percentage of the default track time or laps, whichever happens first. This will vary from track to track.

### Race Laps
Set the length of the race session in laps.

### Race Time
Set the length of the race session in minutes.

### Track Limits Points Allowed
In race sessions warning points are awarded for Track Limits violations. If the number of points earned in one violation exceeds 3 points, the driver will be given an automatic drive through.

Otherwise the points are added to a tally, and at a set amount of points a drive through penalty will be given. If you significantly go over the points tally via large cuts you will be given a stop go penalty, with the stop time variable to the severity of the cuts.

### Weather Preset
Select a weather preset.

### RealRoad
Select a RealRoad preset to change the amount of grip. Heavier presets will have more rubber build up and will provide more grip.

Note that this setting is disabled unless the **Weather Preset** setting above is set to **Scripted**.

### RealRoad Wet
Select the amount of water on track at the start of the session.

Note that this setting is disabled unless the **Weather Preset** setting above is set to **Scripted**.

### RealRoad Time Scale
Multiplying the RealRoad time scale will accelerate the speed of rubber build-up, track drying up and getting wet in the rain.

### Sky
Select the type of cloud cover. If you cycle through the types of cloud cover you'll reach the different levels of rainfall.

### Rain Chance
Each session is divided in 5 slots. You can tweak the chance of rain for each slot in order to create very dynamic sessions.

### Humidity
Humidity affects the evaporation of water when the track is wet. Note that when it's raining, humidity will be high regardless of this setting.

### Temperature
Changes the ambient temperature. A higher temperature will make the engine run hotter.

### Wind Speed
Changes the wind speed.

### Wind Direction
Changes the wind direction.